 ; Ŀ
 ;   Oshad - change 2010/09/09 or 10/09/09 to 2010.09.09.                  
 ;   See also Dasho which does the opposite.                               
 ;   Copyright 1995, 1997, 1998, 2004, 2010 by Rocket Software Ltd.        
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Oshad - reformat a date.                                   
 ;   Arguments: Tess, a string which may be a date in yy/mm/dd format.     
 ;   Calls Splat, returns a new date string (yyyy.mm.dd) or nil.           
 ;   Note: don't screw up the argument order in wcmatch.                   
 ;   It's (Wcmatch  String  Wild_Card_Pattern).                            
 ; 
 (DEFUN OSHAD (tess / liss yy gnudat)
  (cond ((wcmatch tess "####/##/##")
         (setq liss (splat "/" tess))
         (setq gnudat (strcat (car liss) "." (cadr liss) "." (caddr liss))))
        ((wcmatch tess "##/##/##")
         (setq liss (splat "/" tess))
         (if (>= (read (setq yy (car liss))) 65)
             (setq yy (strcat "19" yy))
             (setq yy (strcat "20" yy)))
         (setq gnudat (strcat yy "." (cadr liss) "." (caddr liss)))))
 gnudat)
 ; Ŀ
 ;   Subroutine Oshad end.                                                 
 ; 

 ; Ŀ
 ;   Mark - mark a point.                                                  
 ;   Arguments: Pa - the point to mark.                                    
 ;              Rad - the marker segment length.                           
 ;              Colo - the marker grdraw line colour.                      
 ; 
 (DEFUN MARK (pa rad colo /)
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) colo)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) colo)
 (princ))
 ; Ŀ
 ;   Mark end.                                                             
 ; 

 ; Ŀ
 ;   Nultch - change one substring to another in everything.               
 ;   Arguments: Notouch - the list of block names not to modify.           
 ;              Proog - date reformatter to call.                          
 ;   Returns a list: number of text entities changed, number of            
 ;   number of attributes changed.                                         
 ; 
 (DEFUN NULTCH (notouch proog / chlin chnum rad ss len num strch enam txt entt
                                                       altr pa attch esub chg)
  (setq chlin 0)
  (setq chnum 0)
  (setq rad (/ (getvar "viewsize") 45))
 ; Ŀ
 ;   Change text.                                                          
 ; 
  (setq ss (ssget "X" (list (cons 0 "TEXT"))))
  (if ss (setq len (strcat "/" (itoa (sslength ss)) ":Txt ")))
  (setq num 0)
  (setq strch 0)
  (while (and ss (setq enam (ssname ss num)))
         (grtext -2 (strcat (itoa (setq num (1+ num))) len))
         (setq txt (cdr (assoc 1 (setq entt (entget enam)))))
         (setq altr (proog txt))
         (if altr                          ; if any changes made
             (progn
                  (setq strch (1+ strch))
                  (setq pa (cdr (assoc 10 entt)))
                  (mark pa rad 1)
                  (entmod (subst (cons 1 altr) (assoc 1 entt) entt)))))
 ; Ŀ
 ;   Attributes.                                                           
 ; 
  (setq num 0)
  (setq attch 0)
  (setq ss (ssget "X" (list (cons 66 1) (cons 0 "INSERT"))))
  (if ss (setq len (strcat "/" (itoa (sslength ss)) ":Att")))
  (while (and ss (setq enam (ssname ss num)))
         (setq esub (entnext enam))
         (grtext -2 (strcat (itoa (setq num (1+ num))) len))
         (setq chg ())
         (while (and (not (member (cdr (assoc 2 (entget enam))) notouch))
                     (/= "SEQEND" (cdr (assoc 0 (setq entt (entget esub))))))
                (setq txt (cdr (assoc 1 entt)))
                (setq altr (proog txt))
                (if altr                    ; if any changes made
                    (progn
                         (setq chg T)
                         (setq attch (1+ attch))
                         (setq pa (cdr (assoc 10 entt)))
                         (mark pa rad 7)
                         (entmod (subst (cons 1 altr) (assoc 1 entt) entt))))
                (setq esub (entnext esub)))
         (if chg (entupd enam)))
 (list strch attch))
 ; Ŀ
 ;   Nultch end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (= (substr name1 (setq len (strlen name1))) " ")
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Oshad.                                                                
 ; 
 (DEFUN C:OSHAD (/ picks *error* notouch chglst)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   This turns off group selection - otherwise entities in groups may     
 ;   be changed twice with bad things happening as a result.               
 ; 
  (setq picks (getvar "pickstyle"))
  (setvar "pickstyle" 0)
 ; Ŀ
 ;   Something is bound to go wrong.                                       
 ; 
  (defun *error* (shk)
   (setvar "pickstyle" picks)
   (command "undo" "end")
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Do it.                                                                
 ; 
  (setq notouch ())
  (setq chglst (nultch notouch oshad))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))